<?php
// =================================================================
// KONFIGURACJA I LOGIKA APLIKACJI
// =================================================================

// --- USTAWIENIA BEZPIECZEŃSTWA ---
// Definiujemy główny katalog, od którego skrypt ma działać.
// __DIR__ to stała PHP zawierająca ścieżkę do katalogu, w którym znajduje się ten skrypt.
// Dzięki temu ograniczamy dostęp tylko do plików w tym folderze i jego podfolderach.
 $baseDir = __DIR__;

// --- SPRAWDZENIE HASŁA ---
session_start();

// Sprawdzamy, czy użytkownik jest już zalogowany
if (!isset($_SESSION['authenticated']) || $_SESSION['authenticated'] !== true) {
    // Jeśli formularz został wysłany, sprawdzamy hasło
    if (isset($_POST['password']) && $_POST['password'] === 'qwerty123') {
        $_SESSION['authenticated'] = true;
    } elseif (isset($_POST['password'])) {
        // Jeśli hasło jest nieprawidłowe, wyświetlamy komunikat
        $error = "Nieprawidłowe hasło!";
    } else {
        // Jeśli nie ma sesji i nie wysłano formularza, wyświetlamy formularz logowania
        ?>
        <!DOCTYPE html>
        <html lang="pl">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Moje Polecajki - Logowanie</title>
            <style>
                * {
                    box-sizing: border-box;
                    margin: 0;
                    padding: 0;
                }
                
                body {
                    font-family: "Courier New", Courier, monospace;
                    background-color: #000000;
                    color: #00ff00;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    height: 100vh;
                    padding: 20px;
                }
                
                .login-container {
                    background-color: #111111;
                    border: 1px solid #00ff00;
                    border-radius: 8px;
                    padding: 30px;
                    width: 100%;
                    max-width: 400px;
                    text-align: center;
                }
                
                .login-container h1 {
                    margin-bottom: 20px;
                    font-size: 1.8rem;
                }
                
                .login-form {
                    display: flex;
                    flex-direction: column;
                    gap: 15px;
                }
                
                .form-group {
                    display: flex;
                    flex-direction: column;
                    align-items: flex-start;
                }
                
                .form-group label {
                    margin-bottom: 5px;
                    font-weight: bold;
                }
                
                .form-group input {
                    width: 100%;
                    padding: 10px;
                    background-color: #000000;
                    border: 1px solid #00ff00;
                    color: #00ff00;
                    border-radius: 4px;
                    font-family: "Courier New", Courier, monospace;
                }
                
                .form-group input:focus {
                    outline: none;
                    box-shadow: 0 0 5px #00ff00;
                }
                
                .login-button {
                    background-color: #111111;
                    color: #00ff00;
                    border: 1px solid #00ff00;
                    padding: 10px 15px;
                    border-radius: 4px;
                    cursor: pointer;
                    font-family: "Courier New", Courier, monospace;
                    font-weight: bold;
                    transition: background-color 0.2s, color 0.2s;
                }
                
                .login-button:hover {
                    background-color: #00ff00;
                    color: #000000;
                }
                
                .error-message {
                    color: #ff4d4d;
                    margin-top: 15px;
                    font-weight: bold;
                }
            </style>
        </head>
        <body>
            <div class="login-container">
                <h1>Moje Polecajki</h1>
                <form method="post" action="" class="login-form">
                    <div class="form-group">
                        <label for="password">Podaj HASŁO:</label>
                        <input type="password" id="password" name="password" required>
                    </div>
                    <button type="submit" class="login-button">Zaloguj</button>
                </form>
                <?php if (isset($error)): ?>
                    <div class="error-message"><?php echo $error; ?></div>
                <?php endif; ?>
            </div>
        </body>
        </html>
        <?php
        exit; // Zatrzymujemy dalsze wykonywanie skryptu
    }
}

// --- OBSŁUGA PARAMETRÓW Z URL ---

// Pobranie aktualnego katalogu z parametru 'dir' w URL.
// Jeśli brak parametru, domyślnie ustawiamy katalog bieżący ('.').
// W tej wersji 'dir' nie jest używany do nawigacji, ale może być przydatny w przyszłości.
 $currentDir = isset($_GET['dir']) ? $_GET['dir'] : '.';

// Pobranie ścieżki do pliku z parametrem 'file' w URL.
 $requestedFile = isset($_GET['file']) ? $_GET['file'] : null;

// --- PRZETWARZANIE I GENEROWANIE HTML ---

// Zmienna przechowująca HTML dla lewego panelu (przeglądarki plików)
 $fileBrowserHtml = '';

// Zmienna przechowująca HTML dla prawego panelu (podglądu zawartości)
 $contentViewerHtml = '';

// Zmienna przechowująca HTML dla przycisków nawigacyjnych
 $navigationHtml = '';

// Budujemy pełną, bezpieczną ścieżkę do systemu plików
 $fullPath = realpath($baseDir . '/' . $currentDir);

// --- KONTROLA BEZPIECZEŃSTWA ---
// Sprawdzamy, czy ścieżka jest prawidłowa i czy znajduje się wewnątrz naszego katalogu bazowego.
// To kluczowe zabezpieczenie przed dostępem do innych części serwera.
if ($fullPath === false || strpos($fullPath, $baseDir) !== 0) {
    // Jeśli ścieżka jest nieprawidłowa lub próbuje wyjść poza bazę, przerywamy działanie.
    die('<h1 style="color:red;">Błąd: Odmowa dostępu.</h1>');
}

// Funkcja do rekurencyjnego skanowania katalogów i tworzenia drzewa plików
function buildFileTree($dir, $baseDir, $currentFile = null) {
    $html = '';
    $items = scandir($dir);
    
    // Sortujemy elementy - najpierw katalogi, potem pliki
    $dirs = [];
    $files = [];
    
    foreach ($items as $item) {
        if ($item == '.' || $item == '..') {
            continue;
        }
        
        $itemPath = $dir . '/' . $item;
        
        if (is_dir($itemPath)) {
            // Sprawdzamy, czy folder nie zaczyna się od kropki (niewidzialny folder)
            if (substr($item, 0, 1) !== '.') {
                $dirs[] = $item;
            }
        } elseif (is_file($itemPath)) {
            $extension = strtolower(pathinfo($item, PATHINFO_EXTENSION));
            // *** ZMIANA: Dodano obsługę plików .txt i .mp4 ***
            if (in_array($extension, ['html', 'htm', 'php', 'pdf', 'txt', 'mp4'])) {
                // Wykluczamy główny plik index.php z listy, aby uniknąć rekurencji
                if ($item === 'index.php') {
                    continue;
                }
                $files[] = $item;
            }
        }
    }
    
    sort($dirs);
    sort($files);
    
    foreach ($dirs as $item) {
        $itemPath = $dir . '/' . $item;
        $relativePath = str_replace($baseDir . '/', '', $itemPath);
        
        $html .= '<div class="folder-item">';
        $html .= '<div class="folder-header" onclick="toggleFolder(this)">';
        $html .= '<span class="folder-toggle">▼</span>';
        $html .= '<span class="folder-name">' . htmlspecialchars($item) . '</span>';
        $html .= '</div>';
        $html .= '<div class="folder-content">';
        $html .= buildFileTree($itemPath, $baseDir, $currentFile);
        $html .= '</div>';
        $html .= '</div>';
    }
    
    foreach ($files as $item) {
        $itemPath = $dir . '/' . $item;
        $relativePath = str_replace($baseDir . '/', '', $itemPath);
        $fileNameWithoutExt = pathinfo($item, PATHINFO_FILENAME);
        
        $activeClass = ($currentFile && $relativePath === $currentFile) ? ' active' : '';
        
        // *** ZMIANA: Usunięto ikony obok nazw plików ***
        
        $html .= '<div class="file-item' . $activeClass . '">';
        $html .= '<a href="?file=' . urlencode($relativePath) . '" class="file-link">' . htmlspecialchars($fileNameWithoutExt) . '</a>';
        $html .= '</div>';
    }
    
    return $html;
}

// Funkcja do znalezienia poprzedniego i następnego pliku
function findAdjacentFiles($currentFile, $baseDir) {
    if (!$currentFile) {
        return ['prev' => null, 'next' => null];
    }
    
    $currentFilePath = realpath($baseDir . '/' . $currentFile);
    if ($currentFilePath === false) return ['prev' => null, 'next' => null];
    
    $currentDir = dirname($currentFilePath);
    
    $allFiles = [];
    $items = scandir($currentDir);
    
    foreach ($items as $item) {
        if ($item == '.' || $item == '..') {
            continue;
        }
        
        $itemPath = $currentDir . '/' . $item;
        
        if (is_file($itemPath)) {
            $extension = strtolower(pathinfo($item, PATHINFO_EXTENSION));
            // *** ZMIANA: Dodano obsługę plików .txt i .mp4 ***
            if (in_array($extension, ['html', 'htm', 'php', 'pdf', 'txt', 'mp4'])) {
                // Wykluczamy główny plik index.php również z nawigacji
                if ($item === 'index.php') {
                    continue;
                }
                $relativePath = str_replace($baseDir . '/', '', $itemPath);
                $allFiles[] = $relativePath;
            }
        }
    }
    
    sort($allFiles);
    
    $currentIndex = array_search($currentFile, $allFiles);
    
    $prev = ($currentIndex > 0) ? $allFiles[$currentIndex - 1] : null;
    $next = ($currentIndex < count($allFiles) - 1) ? $allFiles[$currentIndex + 1] : null;
    
    return ['prev' => $prev, 'next' => $next];
}

// --- LOGIKA PRZEGLĄDARKI PLIKÓW (LEWY PANEL) ---
// Budowanie drzewa plików
 $fileTreeHtml = buildFileTree($baseDir, $baseDir, $requestedFile);

// --- LOGIKA PRZYCISKÓW NAWIGACYJNYCH ---
 $adjacentFiles = findAdjacentFiles($requestedFile, $baseDir);

 $navigationHtml .= '<div class="navigation-buttons">';
 $navigationHtml .= '<a href="#" class="nav-button"';
if ($adjacentFiles['prev']) {
    $navigationHtml .= ' onclick="window.location.href=\'?file=' . urlencode($adjacentFiles['prev']) . '\'"';
} else {
    $navigationHtml .= ' disabled';
}
 $navigationHtml .= '>&lt;WSTECZ</a>';

 $navigationHtml .= '<a href="index.php" class="nav-button">GŁÓWNA</a>';

 $navigationHtml .= '<a href="#" class="nav-button"';
if ($adjacentFiles['next']) {
    $navigationHtml .= ' onclick="window.location.href=\'?file=' . urlencode($adjacentFiles['next']) . '\'"';
} else {
    $navigationHtml .= ' disabled';
}
 $navigationHtml .= '>NASTĘPNA&gt;</a>';
 $navigationHtml .= '</div>';


// --- LOGIKA PODGLĄDU ZAWARTOŚCI (PRAWY PANEL) ---
if ($requestedFile) {
    // Budujemy pełną ścieżkę do żądanego pliku
    $fullFilePath = realpath($baseDir . '/' . $requestedFile);
    $extension = strtolower(pathinfo($fullFilePath, PATHINFO_EXTENSION));

    // Dodajemy warunek, aby nigdy nie próbować dołączać samego siebie
    $scriptName = basename($_SERVER['SCRIPT_NAME']);
    if ($fullFilePath && strpos($fullFilePath, $baseDir) === 0 && is_file($fullFilePath) && basename($fullFilePath) !== $scriptName) {
        
        if ($extension === 'pdf') {
            // Obsługa plików PDF - używamy wbudowanego czytnika PDF w przeglądarce
            $contentViewerHtml .= '<div class="file-content">';
            $contentViewerHtml .= '<iframe src="' . htmlspecialchars($requestedFile) . '" width="100%" height="100%" style="border: none; min-height: 90vh;"></iframe>';
            $contentViewerHtml .= '</div>';
        } elseif ($extension === 'php') {
            // *** ZMIANA: Zmieniono obsługę plików PHP, aby zachować ich oryginalne style i formatowanie ***
            $contentViewerHtml .= '<div class="file-content php-content">';
            
            // Tworzymy tymczasowy bufor, aby przechwycić wynik wykonania skryptu
            ob_start();
            
            // Dołączamy plik PHP, aby wykonać jego kod
            include $fullFilePath;
            
            // Pobieramy zawartość bufora
            $phpContent = ob_get_clean();
            
            // Jeśli plik nie ma pełnej struktury HTML, dodajemy go do naszego kontenera
            if (!preg_match('/<!DOCTYPE/i', $phpContent)) {
                // Tworzymy kontener z naszymi stylami
                $contentViewerHtml .= '<div id="php-content-wrapper" style="background-color: #000000; color: #00ff00; font-family: \'Courier New\', Courier, monospace; padding: 1rem;">';
                
                // Przetwarzamy zawartość, aby usunąć style i zachować skrypty
                $phpContent = preg_replace('/<style[^>]*>.*?<\/style>/is', '', $phpContent);
                $phpContent = preg_replace('/<link[^>]*>/is', '', $phpContent);
                
                // Zastępujemy znaczniki body na div, aby zachować strukturę
                $phpContent = preg_replace('/<body[^>]*>/', '<div>', $phpContent);
                $phpContent = preg_replace('/<\/body>/', '</div>', $phpContent);
                
                // Usuwamy znaczniki html, head i title
                $phpContent = preg_replace('/<!DOCTYPE[^>]*>/', '', $phpContent);
                $phpContent = preg_replace('/<html[^>]*>/', '', $phpContent);
                $phpContent = preg_replace('/<\/html>/', '', $phpContent);
                $phpContent = preg_replace('/<head[^>]*>.*?<\/head>/is', '', $phpContent);
                $phpContent = preg_replace('/<title[^>]*>.*?<\/title>/is', '', $phpContent);
                
                // Zapisujemy skrypty, aby je później dodać
                preg_match_all('/<script[^>]*>.*?<\/script>/is', $phpContent, $scripts);
                $phpContent = preg_replace('/<script[^>]*>.*?<\/script>/is', '', $phpContent);
                
                // Dodajemy przetworzoną zawartość
                $contentViewerHtml .= $phpContent;
                
                // Zamykamy kontener
                $contentViewerHtml .= '</div>';
                
                // Dodajemy skrypty, które będą działać w naszym kontekście
                foreach ($scripts[0] as $script) {
                    $contentViewerHtml .= $script;
                }
            } else {
                // Jeśli ma pełną strukturę HTML, wstawiamy go w ramce iframe z naszymi stylami
                $tempFile = tempnam(sys_get_temp_dir(), 'php_preview_');
                file_put_contents($tempFile, $phpContent);
                
                // Modyfikujemy HTML, aby zastosować nasze style
                $modifiedContent = $phpContent;
                
                // Dodajemy nasze style do sekcji head
                $customStyles = '<style>
                    body { 
                        background-color: #000000 !important; 
                        color: #00ff00 !important; 
                        font-family: "Courier New", Courier, monospace !important; 
                    }
                    * { 
                        color: #00ff00 !important; 
                    }
                </style>';
                
                if (preg_match('/<head[^>]*>/i', $modifiedContent)) {
                    $modifiedContent = preg_replace('/(<head[^>]*>)/i', '$1' . $customStyles, $modifiedContent);
                } else {
                    $modifiedContent = preg_replace('/(<html[^>]*>)/i', '$1<head>' . $customStyles . '</head>', $modifiedContent);
                }
                
                // Zapisujemy zmodyfikowaną zawartość
                file_put_contents($tempFile, $modifiedContent);
                
                // Tworzymy URL do tymczasowego pliku
                $tempUrl = 'data:text/html;base64,' . base64_encode($modifiedContent);
                
                $contentViewerHtml .= '<iframe src="' . $tempUrl . '" width="100%" height="100%" style="border: none; min-height: 90vh;"></iframe>';
            }
            
            $contentViewerHtml .= '</div>';
        } elseif ($extension === 'txt') {
            // *** ZMIANA: Dodano obsługę plików .txt ***
            $txtContent = file_get_contents($fullFilePath);
            // Konwertujemy znaki specjalne na encje HTML, aby zachować formatowanie (np. <, >, &)
            // Używamy nl2br, aby zachować przełamania linii
            $contentViewerHtml .= '<div class="file-content">' . nl2br(htmlspecialchars($txtContent)) . '</div>';
        } elseif ($extension === 'mp4') {
            // *** ZMIANA: Dodano obsługę plików .mp4 ***
            $contentViewerHtml .= '<div class="file-content">';
            $contentViewerHtml .= '<video width="calc(100% - 4px)" height="auto" controls style="margin: 2px;">';
            $contentViewerHtml .= '<source src="' . htmlspecialchars($requestedFile) . '" type="video/mp4">';
            $contentViewerHtml .= 'Twoja przeglądarka nie obsługuje odtwarzacza wideo.';
            $contentViewerHtml .= '</video>';
            $contentViewerHtml .= '</div>';
        } else {
            // Dla plików HTML/HTM - wczytujemy zawartość
            $htmlContent = file_get_contents($fullFilePath);
            
            // Usuwamy style z plików HTML, aby nie interferowały z naszymi
            $htmlContent = preg_replace('/<!DOCTYPE[^>]*>/', '', $htmlContent);
            $htmlContent = preg_replace('/<html[^>]*>/', '', $htmlContent);
            $htmlContent = preg_replace('/<\/html>/', '', $htmlContent);
            $htmlContent = preg_replace('/<head[^>]*>.*?<\/head>/is', '', $htmlContent);
            $htmlContent = preg_replace('/<body[^>]*>/', '', $htmlContent);
            $htmlContent = preg_replace('/<\/body>/', '', $htmlContent);
            $htmlContent = preg_replace('/<style[^>]*>.*?<\/style>/is', '', $htmlContent);
            $htmlContent = preg_replace('/<link[^>]*>/is', '', $htmlContent);
            $htmlContent = preg_replace('/<script[^>]*>.*?<\/script>/is', '', $htmlContent);
            
            // --- OBSŁUGA KODOWANIA BEZ MBSTRING ---
            // Używamy iconv jako alternatywy dla mbstring, jeśli jest dostępne
            if (function_exists('iconv')) {
                // Próbujemy wykryć kodowanie i przekonwertować na UTF-8
                // Sprawdzamy, czy zawartość ma znacznik meta z kodowaniem
                if (preg_match('/charset=([^\s">]+)/i', $htmlContent, $matches)) {
                    $detectedEncoding = strtoupper($matches[1]);
                    // Konwertujemy tylko jeśli kodowanie jest inne niż UTF-8
                    if ($detectedEncoding !== 'UTF-8') {
                        $htmlContent = iconv($detectedEncoding, 'UTF-8//IGNORE', $htmlContent);
                        // Aktualizujemy znacznik meta na UTF-8
                        $htmlContent = preg_replace('/charset=[^\s">]+/i', 'charset=UTF-8', $htmlContent);
                    }
                } else {
                    // Jeśli nie ma znacznika meta, próbujemy przekonwertować z najczęstszych kodowań
                    $encodingsToTry = ['ISO-8859-2', 'WINDOWS-1250', 'UTF-8'];
                    foreach ($encodingsToTry as $encoding) {
                        $converted = @iconv($encoding, 'UTF-8//IGNORE', $htmlContent);
                        if ($converted !== false && strlen($converted) > 0) {
                            $htmlContent = $converted;
                            break;
                        }
                    }
                }
            }
            
            $contentViewerHtml .= '<div class="file-content">' . $htmlContent . '</div>';
        }
    } else {
        // Jeśli ścieżka do pliku jest nieprawidłowa lub to jest plik index.php
        $contentViewerHtml = '<p style="color: #ff4d4d; font-weight: bold;">Błąd: Nie można załadować wskazanego pliku lub plik nie istnieje.</p>';
    }
} else {
    // Jeśli nie wybrano pliku, wyświetlamy stronę główną
    $contentViewerHtml = '<div class="welcome-message">';
    $contentViewerHtml .= '<h2>Witaj w Moich Polecajkach!</h2>';
    $contentViewerHtml .= '<p>Wybierz stronę z lewego panelu, aby rozpocząć przeglądanie.</p>';
    $contentViewerHtml .= '</div>';
}

?>
<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Moje Polecajki</title>
    <style>
        /* --- PODSTAWOWE STYLIZOWANIE --- */
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        
        body {
            font-family: "Courier New", Courier, monospace;
            margin: 0;
            padding: 0;
            background-color: #000000;
            color: #00ff00;
            font-size: 16px; /* Bazowy rozmiar czcionki dla lepszej skalowalności */
        }

        header {
            background-color: #1a1a1a;
            color: #00ff00;
            padding: 1rem;
            text-align: center;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            border-bottom: 1px solid #00ff00;
            position: relative;
        }

        header h1 {
            margin: 0;
            font-size: 1.8rem;
        }
        
        .menu-toggle {
            display: none;
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: 1px solid #00ff00;
            color: #00ff00;
            font-size: 1.5rem;
            padding: 5px 10px;
            cursor: pointer;
            border-radius: 4px;
        }

        main {
            display: flex;
            height: calc(100vh - 80px); /* 100% wysokości ekranu minus wysokość nagłówka */
        }

        /* --- LEWY PANEL: PRZEGLĄDARKA PLIKÓW --- */
        #file-browser {
            width: 300px;
            flex-shrink: 0; /* Zapobiega kurczeniu się panelu, co gwarantuje stałą szerokość */
            background-color: #111111;
            border-right: 1px solid #00ff00;
            padding: 0; /* Usunięcie paddingu, aby przyciski przylegały do krawędzi */
            overflow-y: auto; /* Przewijanie, jeśli jest dużo plików */
            box-sizing: border-box;
            transition: transform 0.3s ease;
            display: flex;
            flex-direction: column;
        }

        .navigation-buttons {
            display: flex;
            justify-content: space-between;
            padding: 10px;
            border-bottom: 1px solid #00ff00;
            background-color: #1a1a1a;
            flex-shrink: 0; /* Zapobiega kurczeniu się */
        }

        .nav-button {
            display: inline-block;
            padding: 8px 12px;
            background-color: #333;
            color: #00ff00;
            border: 1px solid #00ff00;
            text-decoration: none;
            border-radius: 4px;
            transition: background-color 0.2s;
            font-weight: bold;
            font-size: 0.9rem;
            text-align: center;
            flex-grow: 1;
            margin: 0 2px;
        }

        .nav-button:hover:not([disabled]) {
            background-color: #00ff00;
            color: #000;
        }

        .nav-button[disabled] {
            color: #666;
            border-color: #666;
            cursor: not-allowed;
            background-color: transparent;
        }

        .file-tree {
            padding: 1rem;
            overflow-y: auto;
            flex-grow: 1;
        }

        .folder-item {
            margin-bottom: 5px;
        }

        .folder-header {
            display: flex;
            align-items: center;
            padding: 5px;
            cursor: pointer;
            border-radius: 4px;
            transition: background-color 0.2s;
        }

        .folder-header:hover {
            background-color: #333333;
        }

        .folder-toggle {
            margin-right: 5px;
            width: 15px;
            text-align: center;
        }

        .folder-content {
            margin-left: 20px;
            display: block;
        }

        .folder-content.collapsed {
            display: none;
        }

        .file-item {
            margin-bottom: 2px;
        }

        .file-item.active {
            background-color: #333;
        }

        .file-link {
            display: block;
            padding: 5px;
            text-decoration: none;
            color: #00ff00;
            border-radius: 4px;
            transition: background-color 0.2s;
        }

        .file-link:hover {
            background-color: #333333;
        }

        /* --- PRAWY PANEL: PODGLĄD ZAWARTOŚCI --- */
        #content-viewer {
            flex-grow: 1; /* Zajmuje pozostałą przestrzeń */
            padding: 1.5rem;
            overflow-y: auto; /* Przewijanie, jeśli zawartość jest długa */
            background-color: #000000;
        }

        .file-content {
            border: none; /* Usunięcie obramowania */
            padding: 0; /* Usunięcie dopełnienia */
            background-color: transparent; /* Usunięcie tła */
            border-radius: 0; /* Usunięcie zaokrąglonych rogów */
            min-height: 200px;
            white-space: pre-wrap; /* *** ZMIANA: Zapewnia zachowanie białych znaków i zawijanie tekstu dla .txt *** */
            word-wrap: break-word; /* *** ZMIANA: Zapewnia łamanie długich linii *** */
        }
        
        /* *** ZMIANA: Dodano specjalne style dla zawartości PHP *** */
        .php-content {
            width: 100%;
            height: 90vh;
            overflow: auto;
        }
        
        /* Style dla treści wczytanych plików */
        .file-content {
            font-family: "Courier New", Courier, monospace;
            color: #00ff00;
        }

        .file-content img {
            max-width: 100%;
            height: auto;
        }

        .welcome-message {
            text-align: center;
            margin-top: 50px;
        }

        .welcome-message h2 {
            margin-bottom: 20px;
            font-size: 2rem;
        }
        
        /* --- RESPONSYWNOŚĆ --- */
        
        /* Dla tabletów */
        @media screen and (max-width: 992px) {
            #file-browser {
                width: 250px;
            }
            
            header h1 {
                font-size: 1.6rem;
            }
        }
        
        /* Dla urządzeń mobilnych */
        @media screen and (max-width: 768px) {
            .menu-toggle {
                display: block;
            }
            
            #file-browser {
                position: absolute;
                left: 0;
                top: 80px; /* Wysokość nagłówka */
                height: calc(100vh - 80px);
                z-index: 1000;
                transform: translateX(-100%);
            }
            
            #file-browser.active {
                transform: translateX(0);
            }
            
            #content-viewer {
                width: 100%;
                padding: 1rem;
            }
            
            main {
                flex-direction: column;
            }
            
            header h1 {
                font-size: 1.4rem;
                padding-left: 40px; /* Miejsce na przycisk menu */
            }
            
            .nav-button {
                padding: 6px 8px;
                font-size: 0.8rem;
            }
        }
        
        /* Dla małych telefonów */
        @media screen and (max-width: 480px) {
            body {
                font-size: 14px;
            }
            
            header h1 {
                font-size: 1.2rem;
            }
            
            #file-browser {
                width: 100%;
            }
            
            #content-viewer {
                padding: 0.8rem;
            }
            
            .nav-button {
                padding: 5px 6px;
                font-size: 0.7rem;
            }
        }
        
        /* --- POPRAWKA: Style dla zawartości ładowanych plików --- */
        .file-content * {
            max-width: 100% !important;
            box-sizing: border-box !important;
        }
        
        .file-content table {
            width: 100% !important;
            border-collapse: collapse !important;
        }
        
        .file-content img {
            max-width: 100% !important;
            height: auto !important;
        }
        
        .file-content iframe {
            max-width: 100% !important;
        }
        
        /* *** ZMIANA: Dodano style dla odtwarzacza wideo *** */
        .file-content video {
            max-width: 100%;
            height: auto;
            display: block;
            margin: 0 auto;
        }
    </style>
</head>
<body>

    <header>
        <button class="menu-toggle" id="menuToggle">☰</button>
        <h1>Moje Polecajki</h1>
    </header>

    <main>
        <nav id="file-browser">
            <?php echo $navigationHtml; ?>
            <div class="file-tree">
                <?php echo $fileTreeHtml; ?>
            </div>
        </nav>

        <section id="content-viewer">
            <?php echo $contentViewerHtml; ?>
        </section>
    </main>

    <script>
        // Obsługa przycisku menu na urządzeniach mobilnych
        document.addEventListener('DOMContentLoaded', function() {
            const menuToggle = document.getElementById('menuToggle');
            const fileBrowser = document.getElementById('file-browser');
            
            menuToggle.addEventListener('click', function() {
                fileBrowser.classList.toggle('active');
            });
            
            // Zamknij panel po kliknięciu w link na urządzeniach mobilnych
            const links = document.querySelectorAll('.file-link');
            links.forEach(link => {
                link.addEventListener('click', function() {
                    if (window.innerWidth <= 768) {
                        fileBrowser.classList.remove('active');
                    }
                });
            });
        });

        // Funkcja do zwijania i rozwijania folderów
        function toggleFolder(element) {
            const content = element.nextElementSibling;
            const toggle = element.querySelector('.folder-toggle');
            
            if (content.classList.contains('collapsed')) {
                content.classList.remove('collapsed');
                toggle.textContent = '▼';
            } else {
                content.classList.add('collapsed');
                toggle.textContent = '▶';
            }
        }
    </script>
</body>
</html>